/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Wcl_WButtonNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.FallBackCommandEvent;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclProxyActionEventRequest;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclProxyFallBackActionEventRequest;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclProxyRequest;
import com.ibm.hwmca.fw.servlet.util.HMCCustomScope;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.core.TriggerContext;
import com.ibm.ui.framework.IllegalUserDataException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WclEventProxyManager {
    private static final String TRACE_MASKT = "XPMWEPMT";
    private static final String TRACE_MASKF = "XPMWEPMF";
    private static final String TRACE_MASKD = "XPMWEPMD";
    private PmDataBean dataBean = null;
    private HMCCustomScope hmcCustomScope = null;
    private List requests = new ArrayList();
    private ArrayList subordinates = null;
    private String pmodTraceId = null;
    private EventControl eventControl = new EventControl();
    private boolean postTriggerActive = false;
    private WclEventProxyManager superiorProxyManager = null;
    private boolean actionEventExists = false;

    public WclEventProxyManager(PmDataBean dataBean, HMCCustomScope hmcCustomScope, String pmodTraceId) {
        Trace.trace(TRACE_MASKF, "Pmod(" + pmodTraceId + ") - WclEventProxyManager: <ctor>");
        this.dataBean = dataBean;
        this.hmcCustomScope = hmcCustomScope;
        this.pmodTraceId = pmodTraceId;
    }

    public void setCancelCommandEventData(Wcl_WButtonNode cceNode, Object cceAttribute, String cceCommand) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: setCancelCommandEventData()");
        this.eventControl.cceNode = cceNode;
        this.eventControl.cceAttribute = cceAttribute;
        this.eventControl.cceCommand = cceCommand;
    }

    public void fireSyntheticTimeChooserCancelEvent(TriggerContext tc) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: fireSyntheticTimeChooserCancelEvent()");
        this.eventControl.fireSyntheticTimeChooserCancelEvent(tc);
    }

    public void setCancelEvent(boolean cancelEvent) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: setCancelEvent(" + cancelEvent + ")");
        this.eventControl.cancelEvent = cancelEvent;
    }

    public void addSubordinateProxy(WclEventProxyManager wclEventProxy) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager.addSubordinateProxy()");
        if (this.subordinates == null) {
            this.subordinates = new ArrayList();
        }
        this.subordinates.add(wclEventProxy);
        wclEventProxy.setEventControl(this.eventControl);
    }

    public void removeSubordinateProxy(WclEventProxyManager wclEventProxy) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager.removeSubordinateProxy()");
        if (this.subordinates != null) {
            if (this.subordinates.contains(wclEventProxy)) {
                this.subordinates.remove(wclEventProxy);
            } else {
                Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: Warning, subordinate unknown, ignoring invocation.");
            }
        } else {
            Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: Warning, no subordinates existed, ignoring invocation.");
        }
    }

    public void setSuperiorProxy(WclEventProxyManager superiorProxyManager) {
        this.superiorProxyManager = superiorProxyManager;
    }

    public void dispose() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: dispose()");
        if (this.superiorProxyManager != null) {
            this.superiorProxyManager.removeSubordinateProxy(this);
        }
    }

    void setEventControl(EventControl eventControl) {
        this.eventControl = eventControl;
    }

    public PmDataBean getBean() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: getBean()");
        return this.dataBean;
    }

    public HMCCustomScope getScope() {
        return this.hmcCustomScope;
    }

    public void preTriggerManager() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: preTriggerManager()");
        this.requests.clear();
        if (this.subordinates != null) {
            Iterator iterator = ((List)this.subordinates.clone()).iterator();
            while (iterator.hasNext()) {
                ((WclEventProxyManager)iterator.next()).preTriggerManager();
            }
        }
        this.actionEventExists = false;
        this.eventControl.driveActions = true;
        this.eventControl.cancelEvent = false;
    }

    public void failedTriggerManager() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: failedTriggerManager()");
        if (this.subordinates != null) {
            Iterator iterator = ((List)this.subordinates.clone()).iterator();
            while (iterator.hasNext()) {
                ((WclEventProxyManager)iterator.next()).failedTriggerManager();
            }
        }
    }

    public void driveNonActionEvents() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager:driveNonActionEvents()");
        Iterator iterator = ((List)((ArrayList)this.requests).clone()).iterator();
        while (iterator.hasNext()) {
            WclProxyRequest request = (WclProxyRequest)iterator.next();
            try {
                if (request instanceof WclProxyActionEventRequest) continue;
                Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: processing request: " + request);
                request.execute();
            }
            catch (IllegalUserDataException e) {
                Trace.trace(TRACE_MASKT, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: Non-action resulted in IllegalUserDataException, continuing with remaining non-actions (Action events will be suppressed). " + (Object)((Object)e));
                this.eventControl.driveActions = false;
            }
        }
        if (this.subordinates != null) {
            iterator = ((List)this.subordinates.clone()).iterator();
            while (iterator.hasNext()) {
                ((WclEventProxyManager)iterator.next()).driveNonActionEvents();
            }
        }
    }

    protected void driveActionEvents() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager:driveActionEvents()");
        Iterator iterator = ((List)((ArrayList)this.requests).clone()).iterator();
        while (this.eventControl.driveActions && iterator.hasNext()) {
            WclProxyRequest request = (WclProxyRequest)iterator.next();
            try {
                if (!(request instanceof WclProxyActionEventRequest)) continue;
                if (this.actionEventExists && request instanceof WclProxyFallBackActionEventRequest) {
                    Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: Supressing 'fall back' action, pure action exists.");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: processing request: " + request);
                request.execute();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: Action event resulted in exception.");
                Trace.trace(TRACE_MASKT, e);
                Trace.trace(TRACE_MASKT, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: throwing back to task interface.");
                throw new RuntimeException("WclEventProxyManager catches exception while driving action events", e);
            }
        }
        if (this.eventControl.driveActions && this.subordinates != null) {
            iterator = ((List)this.subordinates.clone()).iterator();
            while (iterator.hasNext()) {
                ((WclEventProxyManager)iterator.next()).driveActionEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTriggerManager() {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: postTriggerManager() (" + this + ")");
        try {
            this.postTriggerActive = true;
            if (!this.eventControl.cancelEvent) {
                this.driveNonActionEvents();
            } else {
                Trace.trace(TRACE_MASKT, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: CANCEL event noted, skipping non-Action Events.");
            }
            if (this.eventControl.driveActions) {
                this.driveActionEvents();
            }
            Object var2_1 = null;
            this.postTriggerActive = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postTriggerActive = false;
            throw throwable;
        }
    }

    public void queueRequest(WclProxyRequest request) {
        Trace.trace(TRACE_MASKF, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: queueRequest(" + request + ") (" + this + ")");
        if (!this.postTriggerActive) {
            this.requests.add(request);
            if (request instanceof WclProxyActionEventRequest && !(request instanceof WclProxyFallBackActionEventRequest)) {
                this.actionEventExists = true;
            }
        } else {
            Trace.trace(TRACE_MASKD, "Pmod(" + this.pmodTraceId + ") - WclEventProxyManager: queueRequest() supresses request due to active postTriggerManager() call.");
        }
    }

    private static class EventControl {
        boolean driveActions = true;
        boolean cancelEvent = false;
        Wcl_WButtonNode cceNode = null;
        Object cceAttribute = null;
        String cceCommand = null;

        private EventControl() {
        }

        public void fireSyntheticTimeChooserCancelEvent(TriggerContext tc) {
            Trace.trace(WclEventProxyManager.TRACE_MASKF, "WclEventProxyManager (eventControl): fireSyntheticTimeChooserCancelEvent()");
            if (this.cceNode != null) {
                this.cceNode.commandPerformed(new FallBackCommandEvent(this.cceAttribute, tc, this.cceCommand));
            } else {
                Trace.trace(WclEventProxyManager.TRACE_MASKF, "WclEventProxyManager (eventControl): fireSyntheticTimeChooserCancelEvent() unable to locate a cancel event data");
            }
        }
    }
}

